package labirinto;

import java.util.Observable;

import labirinto.tests.LabirintoGame;
import labirinto.ui.ControlPanel;
import labirinto.ui.DeathDialog;
import labirinto.ui.LabPanel;
import labirinto.ui.VictoryDialog;

/**
 * Istanzia il giocatore che ha bisogno dell'istanza di Lab.getLab(), cioè del
 * labirinto
 * 
 * @author koelio
 * @param room
 *            stanza corrente
 * @param rooms
 *            il labirinto, cioè tutte le istanze delle stanze dello stesso
 * 
 */
public class Player extends Observable {

	private Stanza room;
	private Stanza[][] rooms;
	private int x, y;

	public Player(Stanza[][] rooms) {
		this.rooms = rooms;
	}

	/**
	 * Serve per leventuale salto oppure l'iniziazione del programma
	 * 
	 * @see LabirintoGame
	 * @param x
	 * @param y
	 */
	public void setRoom(int x, int y) {
		this.x = x;
		this.y = y;
		this.room = rooms[x][y];
		room.checkVictory();
		setChanged();
		notifyObservers();
	}

	// public Stanza getRoom() {
	// return this.room;
	// }

	/**
	 * necessario per l'UI, l'Observer LabPanel
	 * 
	 * @see LabPanel
	 * @return vettore di posizioni che aggiorna il cerchio nel Viewer (vista)
	 */
	public int[] getPos() {
		int[] pos = { x, y };
		return pos;
	}

	/**
	 * La chiave del movimento: con il Controller si setta la direzione: 1 = su,
	 * 2= destra, 3= giù, 4= sinistra; e lo switch compara la direzione col tipo
	 * di muro contro cui si va e poi imposta la stanza successiva in caso di
	 * porta o passaggio ( non implementato in tempo...)
	 * 
	 * @see ControlPanel
	 * @param dir
	 */
	public void setDir(int dir) {
		switch (room.getMura()[dir - 1].getType()) {
		case 1:// muro
			System.out.println("non passi");
			break;

		case 2:// porta

			switch (dir) {
			case 1:
				// vai su
				setRoom(x, y - 1);
				break;
			case 2:
				// vai destra
				setRoom(x + 1, y);
				break;
			case 3:
				// vai giu
				setRoom(x, y + 1);
				break;
			case 4:
				// vai sinistra
				setRoom(x - 1, y);
				break;
			default: // non vai
				break;
			}

			break;
		case 3:// baratro

			try {
				throw new DeathException("Sei morto.");
			} catch (DeathException e) {
				DeathDialog dialog = new DeathDialog(e);
				dialog.setVisible(true);
				System.exit(0);
			}
			
			break;
		case 4:// passaggio (temporaneamente implementato come random..)
			System.out.println("Wormhole!");
			setRoom(room.getMura()[dir - 1].getTeleport()[0],
					room.getMura()[dir - 1].getTeleport()[1]);
			break;
		default:
			System.out.println("sei finito nell'iperspazio");
			break;

		}// end switch

		try {
			if (room.checkVictory()) {
				throw new VictoryException("Hai vinto!");
			}

		} catch (VictoryException e) {
			VictoryDialog dialog = new VictoryDialog(e);
			dialog.setVisible(true);
			System.exit(0);
		}
		

	}
}
